Scriptname RaceMenuPluginCitrus extends RaceMenuBase

;Ranges
float Property SCALE_MIN = 0.10 AutoReadOnly ; Set this to the min value for a scale slider, cannot be negative nor zero, do no make it smaller than 0.01, if you want smaller than that, you can use the hidden slider.
float Property SCALE_MAX = 5.00 AutoReadOnly ; Set this to the max value for a scale slider
float Property SCALE_STEPPING = 0.01 AutoReadOnly ; Set this to the value a scale slider steps to

;Citrus
string Property NINODE_LEFT_SCALEBREAST = "NPC L ScaleBreast" AutoReadOnly
string Property NINODE_RIGHT_SCALEBREAST = "NPC R ScaleBreast" AutoReadOnly
string Property NINODE_LEFT_SCALEBUTT = "NPC R ScaleButt" AutoReadOnly
string Property NINODE_RIGHT_SCALEBUTT = "NPC L ScaleButt" AutoReadOnly

;Callbacks Table
string Property CALLBACK_LEFT_SCALEBREAST = "CitrusChangeLeftScaleBreast" AutoReadOnly
string Property CALLBACK_RIGHT_SCALEBREAST = "CitrusChangeRightScaleBreast" AutoReadOnly
string Property CALLBACK_LEFT_SCALEBUTT = "CitrusChangeLeftScaleButt" AutoReadOnly
string Property CALLBACK_RIGHT_SCALEBUTT = "CitrusChangeRightScaleButt" AutoReadOnly

string Property CATEGORY_KEY = "rsm_citrus_scale" AutoReadOnly

; NiOverride version data
int Property NIOVERRIDE_VERSION = 6 AutoReadOnly
int Property NIOVERRIDE_SCRIPT_VERSION = 6 AutoReadOnly

; XPMSE version data
float Property XPMSE_VERSION = 3.6 AutoReadOnly
float Property XPMSELIB_VERSION = 3.6 AutoReadOnly

bool _versionValid = false

Event OnCategoryRequest()
	AddCategory(CATEGORY_KEY, "$CATEGORY CITRUS")
EndEvent

Event OnStartup()
	parent.OnStartup()

	int nioverrideVersion = SKSE.GetPluginVersion("NiOverride")
	int nioverrideScriptVersion = NiOverride.GetScriptVersion()

	; Check NiOverride version, disable most features if this fails
	if nioverrideVersion >= NIOVERRIDE_VERSION && nioverrideScriptVersion >= NIOVERRIDE_SCRIPT_VERSION
		_versionValid = true
	Else
		_versionValid = false
	Endif
EndEvent

; Add Custom sliders here
Event OnSliderRequest(Actor target, ActorBase targetBase, Race actorRace, bool isFemale)
	bool requirement = CheckXPMSERequirements(target, isFemale)
	If requirement
		AddSliderEx("$Citrus Left Breast", CATEGORY_KEY, CALLBACK_LEFT_SCALEBREAST, SCALE_MIN, SCALE_MAX, SCALE_STEPPING, GetNodeScale(target, isFemale, NINODE_LEFT_SCALEBREAST))
		AddSliderEx("$Citrus Right Breast", CATEGORY_KEY, CALLBACK_RIGHT_SCALEBREAST, SCALE_MIN, SCALE_MAX, SCALE_STEPPING, GetNodeScale(target, isFemale, NINODE_RIGHT_SCALEBREAST))
		AddSliderEx("$Citrus Left Butt", CATEGORY_KEY, CALLBACK_LEFT_SCALEBUTT, SCALE_MIN, SCALE_MAX, SCALE_STEPPING, GetNodeScale(target, isFemale, NINODE_LEFT_SCALEBUTT))
		AddSliderEx("$Citrus Right Butt", CATEGORY_KEY, CALLBACK_RIGHT_SCALEBUTT, SCALE_MIN, SCALE_MAX, SCALE_STEPPING, GetNodeScale(target, isFemale, NINODE_RIGHT_SCALEBUTT))
	Endif
EndEvent

Event OnSliderChanged(string callback, float value)
	bool isFemale = _targetActorBase.GetSex() as bool
	If _versionValid
		If callback == CALLBACK_LEFT_SCALEBREAST
			SetNodeScale(_targetActor, isFemale, NINODE_LEFT_SCALEBREAST, value)
		Elseif callback == CALLBACK_RIGHT_SCALEBREAST
			SetNodeScale(_targetActor, isFemale, NINODE_RIGHT_SCALEBREAST, value)
		Elseif callback == CALLBACK_LEFT_SCALEBUTT
			SetNodeScale(_targetActor, isFemale, NINODE_LEFT_SCALEBUTT, value)
		Elseif callback == CALLBACK_RIGHT_SCALEBUTT
			SetNodeScale(_targetActor, isFemale, NINODE_RIGHT_SCALEBUTT, value)
		Endif	
	Endif
EndEvent

Function SetNodeScale(Actor akActor, bool isFemale, string nodeName, float value, string modkey = "RMCitrus")
	XPMSELib.SetNodeScale(akActor, isFemale, nodeName, value, modkey)
EndFunction

float Function GetNodeScale(Actor akActor, bool isFemale, string nodeName, string modkey = "RMCitrus")
	return NiOverride.GetNodeTransformScale(akActor, false, isFemale, nodeName, modkey)
EndFunction

bool Function CheckXPMSERequirements(Actor akActor, bool isFemale)
	return XPMSELib.CheckXPMSEVersion(akActor, isFemale, XPMSE_VERSION) &&	XPMSELib.CheckXPMSELibVersion(XPMSELIB_VERSION)
EndFunction